<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwnotes="urn:WebWorks-Footnote-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwsplits wwtoc wwbehaviors wwnotes wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwimaging wwexsldoc"
>
 <xsl:template name="Table-CellWidths">
  <xsl:param name="ParamTable" />
  <xsl:param name="ParamReportAllCellWidths" select="false()" />

  <!-- Locate first table cell -->
  <!--                         -->
  <xsl:variable name="VarSectionTableCells" select="$ParamTable/wwdoc:TableHead[1]/wwdoc:TableRow[1]/wwdoc:TableCell[1] | $ParamTable/wwdoc:TableBody[1]/wwdoc:TableRow[1]/wwdoc:TableCell[1] | $ParamTable/wwdoc:TableFoot[1]/wwdoc:TableRow[1]/wwdoc:TableCell[1]" />
  <xsl:for-each select="$VarSectionTableCells[1]">
   <xsl:variable name="VarFirstTableCell" select="." />

   <!-- Determine cell widths -->
   <!--                       -->
   <xsl:call-template name="Table-RecursiveCellWidths">
    <xsl:with-param name="ParamTable" select="$ParamTable" />
    <xsl:with-param name="ParamTableCell" select="$VarFirstTableCell" />
    <xsl:with-param name="ParamTableCellColumnStartIndex" select="1" />
    <xsl:with-param name="ParamRow" select="1" />
    <xsl:with-param name="ParamRowHasColumnSpans" select="false()" />
    <xsl:with-param name="ParamReportAllCellWidths" select="$ParamReportAllCellWidths" />
   </xsl:call-template>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Table-RecursiveCellWidths">
  <xsl:param name="ParamTable" />
  <xsl:param name="ParamTableCell" />
  <xsl:param name="ParamTableCellColumnStartIndex" />
  <xsl:param name="ParamRow" />
  <xsl:param name="ParamRowHasColumnSpans" />
  <xsl:param name="ParamReportAllCellWidths" />

  <!-- Calculate column span -->
  <!--                       -->
  <xsl:variable name="VarColumnSpan">
   <xsl:variable name="VarColumnSpanHint" select="$ParamTableCell/wwdoc:Style/wwdoc:Attribute[@name = 'column-span']/@value" />
   <xsl:choose>
    <xsl:when test="string-length($VarColumnSpanHint) &gt; 0">
     <xsl:value-of select="$VarColumnSpanHint" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="1" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- Row has column spans? -->
  <!--                       -->
  <xsl:variable name="VarRowHasColumnSpans" select="($ParamRowHasColumnSpans) or (number($VarColumnSpan) &gt; 1)" />

  <!-- End column index -->
  <!--                  -->
  <xsl:variable name="VarTableCellColumnEndIndex" select="$ParamTableCellColumnStartIndex + $VarColumnSpan - 1" />

  <!-- Determine width of column span -->
  <!--                                -->
  <xsl:variable name="VarCellWidth">
   <xsl:call-template name="Table-ColumnWidth">
    <xsl:with-param name="ParamTableColumn" select="$ParamTable/wwdoc:TableColumns/wwdoc:TableColumn[1]" />
    <xsl:with-param name="ParamTableColumnIndex" select="1" />
    <xsl:with-param name="ParamAccumulatedWidth" select="'0pt'" />
    <xsl:with-param name="ParamTableColumnStartIndex" select="$ParamTableCellColumnStartIndex" />
    <xsl:with-param name="ParamTableColumnEndIndex" select="$VarTableCellColumnEndIndex" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Cell width -->
  <!--            -->
  <wwdoc:TableCellWidth id="{$ParamTableCell/@id}" row="{$ParamRow}" width="{$VarCellWidth}" />

  <!-- Recurse -->
  <!--         -->
  <xsl:variable name="VarNextTableCell" select="$ParamTableCell/following-sibling::wwdoc:TableCell[1]" />
  <xsl:choose>
   <!-- More cells in row -->
   <!--                   -->
   <xsl:when test="count($VarNextTableCell) = 1">
    <xsl:call-template name="Table-RecursiveCellWidths">
     <xsl:with-param name="ParamTable" select="$ParamTable" />
     <xsl:with-param name="ParamTableCell" select="$VarNextTableCell" />
     <xsl:with-param name="ParamTableCellColumnStartIndex" select="$VarTableCellColumnEndIndex + 1" />
     <xsl:with-param name="ParamRow" select="$ParamRow" />
     <xsl:with-param name="ParamRowHasColumnSpans" select="$VarRowHasColumnSpans" />
     <xsl:with-param name="ParamReportAllCellWidths" select="$ParamReportAllCellWidths" />
    </xsl:call-template>
   </xsl:when>

   <!-- Row complete -->
   <!--              -->
   <xsl:otherwise>
    <!-- Column spans detected? -->
    <!--                        -->
    <xsl:if test="$ParamReportAllCellWidths or $VarRowHasColumnSpans">
     <!-- Process next row as well -->
     <!--                          -->
     <xsl:variable name="VarNextRowCells" select="$ParamTableCell/parent::wwdoc:TableRow/following-sibling::wwdoc:TableRow[1]/wwdoc:TableCell[1] | $ParamTableCell/parent::wwdoc:TableRow/parent::wwdoc:*/following-sibling::wwdoc:*[1]/wwdoc:TableRow[1]/wwdoc:TableCell[1]" />
     <xsl:for-each select="$VarNextRowCells[1]">
      <xsl:variable name="VarNextRowCell" select="." />

      <!-- Determine cell widths -->
      <!--                       -->
      <xsl:call-template name="Table-RecursiveCellWidths">
       <xsl:with-param name="ParamTable" select="$ParamTable" />
       <xsl:with-param name="ParamTableCell" select="$VarNextRowCell" />
       <xsl:with-param name="ParamTableCellColumnStartIndex" select="1" />
       <xsl:with-param name="ParamRow" select="$ParamRow + 1" />
       <xsl:with-param name="ParamRowHasColumnSpans" select="false()" />
       <xsl:with-param name="ParamReportAllCellWidths" select="$ParamReportAllCellWidths" />
      </xsl:call-template>
     </xsl:for-each>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="Table-ColumnWidth">
  <xsl:param name="ParamTableColumn" />
  <xsl:param name="ParamTableColumnIndex" />
  <xsl:param name="ParamAccumulatedWidth" />
  <xsl:param name="ParamTableColumnStartIndex" />
  <xsl:param name="ParamTableColumnEndIndex" />

  <!-- Determine new accumulated width -->
  <!--                                 -->
  <xsl:variable name="VarAccumulatedWidth">
   <xsl:choose>
    <!-- Extend accumulated width -->
    <!--                          -->
    <xsl:when test="($ParamTableColumnIndex &gt;= $ParamTableColumnStartIndex) and ($ParamTableColumnIndex &lt;= $ParamTableColumnEndIndex)">
     <xsl:variable name="VarAccumulatedNumber" select="wwunits:NumericPrefix($ParamAccumulatedWidth)" />
     <xsl:variable name="VarAccumulatedUnits" select="wwunits:UnitsSuffix($ParamAccumulatedWidth)" />
     <xsl:variable name="VarColumnNumber" select="wwunits:NumericPrefix($ParamTableColumn/@width)" />
     <xsl:variable name="VarColumnUnits" select="wwunits:UnitsSuffix($ParamTableColumn/@width)" />

     <xsl:variable name="VarColumnNumberInAccumulatedUnits" select="wwunits:Convert($VarColumnNumber, $VarColumnUnits, $VarAccumulatedUnits)" />

     <!-- Result -->
     <!--        -->
     <xsl:value-of select="$VarAccumulatedNumber + $VarColumnNumberInAccumulatedUnits" />
     <xsl:value-of select="$VarAccumulatedUnits" />
    </xsl:when>

    <!-- Preserve current accumulated width as is -->
    <!--                                          -->
    <xsl:otherwise>
     <xsl:value-of select="$ParamAccumulatedWidth" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- Emit result or keep accumulating column widths -->
  <!--                                                -->
  <xsl:choose>
   <xsl:when test="$ParamTableColumnIndex = $ParamTableColumnEndIndex">
    <xsl:value-of select="$VarAccumulatedWidth" />
   </xsl:when>

   <xsl:otherwise>
    <xsl:call-template name="Table-ColumnWidth">
     <xsl:with-param name="ParamTableColumn" select="$ParamTableColumn/following-sibling::wwdoc:TableColumn[1]" />
     <xsl:with-param name="ParamTableColumnIndex" select="$ParamTableColumnIndex + 1" />
     <xsl:with-param name="ParamAccumulatedWidth" select="$VarAccumulatedWidth" />
     <xsl:with-param name="ParamTableColumnStartIndex" select="$ParamTableColumnStartIndex" />
     <xsl:with-param name="ParamTableColumnEndIndex" select="$ParamTableColumnEndIndex" />
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="Table-CellWidthsAsPercentage">
  <xsl:param name="ParamTable" />
  <xsl:param name="ParamReportAllCellWidths" select="false()" />

  <!-- Determine cell widths -->
  <!--                       -->
  <xsl:variable name="VarTableCellWidthsAsXML">
   <xsl:call-template name="Table-CellWidths">
    <xsl:with-param name="ParamTable" select="$ParamTable" />
    <xsl:with-param name="ParamReportAllCellWidths" select="$ParamReportAllCellWidths" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarTableCellWidths" select="msxsl:node-set($VarTableCellWidthsAsXML)/wwdoc:TableCellWidth" />

  <!-- Determine table width -->
  <!--                       -->
  <xsl:variable name="VarTableWidth">
   <xsl:call-template name="Table-RowWidth">
    <xsl:with-param name="ParamAccumulatedRowWidth" select="'0pt'" />
    <xsl:with-param name="ParamTableCellWidth" select="$VarTableCellWidths[1]" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Convert to percentage widths -->
  <!--                              -->
  <xsl:apply-templates select="$VarTableCellWidths" mode="wwmode:table-percentage-widths">
   <xsl:with-param name="ParamTableWidth" select="$VarTableWidth" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template name="Table-RowWidth">
  <xsl:param name="ParamAccumulatedRowWidth" />
  <xsl:param name="ParamTableCellWidth" />

  <!-- Updated accumulated row width -->
  <!--                               -->
  <xsl:variable name="VarAccumulatedRowWidthNumber" select="wwunits:NumericPrefix($ParamAccumulatedRowWidth)" />
  <xsl:variable name="VarAccumulatedRowWidthUnits" select="wwunits:UnitsSuffix($ParamAccumulatedRowWidth)" />
  <xsl:variable name="VarTableCellWidthNumber" select="wwunits:NumericPrefix($ParamTableCellWidth/@width)" />
  <xsl:variable name="VarTableCellWidthUnits" select="wwunits:UnitsSuffix($ParamTableCellWidth/@width)" />
  <xsl:variable name="VarTableCellWidthNumberInAccumulatedUnits" select="wwunits:Convert($VarTableCellWidthNumber, $VarTableCellWidthUnits, $VarAccumulatedRowWidthUnits)" />
  <xsl:variable name="VarAccumulatedRowWidth">
   <xsl:value-of select="$VarAccumulatedRowWidthNumber + $VarTableCellWidthNumberInAccumulatedUnits" />
   <xsl:value-of select="$VarAccumulatedRowWidthUnits" />
  </xsl:variable>

  <!-- Locate next table cell width -->
  <!--                              -->
  <xsl:variable name="VarNextTableCellWidth" select="$ParamTableCellWidth/following-sibling::wwdoc:TableCellWidth[1]" />
  <xsl:choose>
   <!-- Check for row change -->
   <!--                      -->
   <xsl:when test="count($VarNextTableCellWidth) = 1">
    <!-- Same row? -->
    <!--           -->
    <xsl:choose>
     <!-- Same Row -->
     <!--          -->
     <xsl:when test="$VarNextTableCellWidth/@row = $ParamTableCellWidth/@row">
      <!-- Accumulate next cell width -->
      <!--                            -->
      <xsl:call-template name="Table-RowWidth">
       <xsl:with-param name="ParamAccumulatedRowWidth" select="$VarAccumulatedRowWidth" />
       <xsl:with-param name="ParamTableCellWidth" select="$VarNextTableCellWidth" />
      </xsl:call-template>
     </xsl:when>

     <!-- Row changed -->
     <!--             -->
     <xsl:otherwise>
      <!-- Return result -->
      <!--               -->
      <xsl:value-of select="$VarAccumulatedRowWidth" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>

   <!-- Row complete, out of table widths -->
   <!--                                   -->
   <xsl:otherwise>
    <xsl:value-of select="$VarAccumulatedRowWidth" />
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <!-- wwmode:table-percentage-widths -->
 <!--                                -->

 <xsl:template match="/" mode="wwmode:table-percentage-widths">
  <xsl:param name="ParamTableWidth" />

  <!-- Nothing to do -->
  <!--               -->
 </xsl:template>


 <xsl:template match="*" mode="wwmode:table-percentage-widths">
  <xsl:param name="ParamTableWidth" />

  <!-- Nothing to do -->
  <!--               -->
 </xsl:template>


 <xsl:template match="wwdoc:TableCellWidth" mode="wwmode:table-percentage-widths">
  <xsl:param name="ParamTableWidth" />
  <xsl:param name="ParamTableCellWidth" select="." />

  <!-- Convert widths to standard units -->
  <!--                                  -->
  <xsl:variable name="VarTableWidthNumber" select="wwunits:NumericPrefix($ParamTableWidth)" />
  <xsl:variable name="VarTableWidthUnits" select="wwunits:UnitsSuffix($ParamTableWidth)" />
  <xsl:variable name="VarTableCellWidthNumber" select="wwunits:NumericPrefix($ParamTableCellWidth/@width)" />
  <xsl:variable name="VarTableCellWidthUnits" select="wwunits:UnitsSuffix($ParamTableCellWidth/@width)" />
  <xsl:variable name="VarTableCellWidthNumberInTableWidthUnits" select="wwunits:Convert($VarTableCellWidthNumber, $VarTableCellWidthUnits, $VarTableWidthUnits)" />

  <!-- Convert to percentage width -->
  <!--                             -->
  <xsl:variable name="VarTableCellWidthAsPercentage" select="floor(($VarTableCellWidthNumberInTableWidthUnits div $VarTableWidthNumber) * 1000) div 10" />

  <!-- Emit table cell width entry -->
  <!--                             -->
  <wwdoc:TableCellWidth>
   <xsl:copy-of select="$ParamTableCellWidth/@*[local-name() != 'width']" />
   <xsl:attribute name="width">
    <xsl:value-of select="$VarTableCellWidthAsPercentage" />
    <xsl:text>%</xsl:text>
   </xsl:attribute>
  </wwdoc:TableCellWidth>
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:table-percentage-widths">
  <xsl:param name="ParamTableWidth" />

  <!-- Nothing to do -->
  <!--               -->
 </xsl:template>
</xsl:stylesheet>
